/*** 1.   ũƮ ***/

SELECT CASE WHEN seq  = 1 THEN 1
	  WHEN seq <= 11 THEN 2
	  WHEN seq <= 111 THEN 3
	  WHEN seq <= 1111 THEN 4
	  WHEN seq <= 11111 THEN 5
	  WHEN seq <= 111111 THEN 6 
	  WHEN seq <= 1111111 THEN 7 
	  END AS gid
	, NEWID() AS txt
	, GETDATE() AS date INTO TB_Hist
FROM (SELECT ROW_NUMBER() OVER ( ORDER BY a.number) seq
	FROM master..spt_values a, (SELECT number 
								FROM master..spt_values 
								WHERE type = 'P' 
								AND number BETWEEN 1 AND 1000) b 
	WHERE a.type = 'P'
	AND a.number BETWEEN 1 AND 1200) c
WHERE seq BETWEEN 1 AND 1111111

CREATE INDEX NIDX01_Hist ON TB_Hist(gid)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

DECLARE @int INT
SET @int = 1

SELECT gid, txt 
FROM TB_Hist
WHERE gid = @int
GO


/*** 6. [TO-BE]   ***/

--(1)  ν Ͽ HISTOGRAM Ȱ
-- ν 
CREATE PROC USP_Hist @int INT
WITH RECOMPILE
AS
SELECT gid, txt
FROM TB_Hist 
WHERE gid = @int
GO

-- ν  
EXEC USP_Hist 1
GO

--(2) UNION ALL  ε   ٸ  ó
--SQL 
DECLARE @int INT
SET @int = 1

SELECT gid, txt
FROM TB_Hist 
WHERE gid IN (1, 2, 3) AND gid = @int
UNION ALL
SELECT gid, txt
FROM TB_Hist 
WHERE gid NOT IN (1, 2, 3) AND gid = @int
GO

--(3) [txt] ÷ Ե ε  
--ε 
DROP INDEX NIDX01_Hist ON TB_Hist 
CREATE INDEX NIDX01_Hist ON TB_Hist (gid) INCLUDE (txt) 
GO

--SQL 
DECLARE @int INT
SET @int = 1

SELECT gid, txt
FROM TB_Hist
WHERE gid = @int
GO
